
# broke.py

'''
  BROKE: average number of flips til odd man out is lost.

  Three players begin with L, M and N dollars.
  On each turn, each player flips a coin.
  All coins have the same bias P.
  If one player is "odd man out", he pays a dollar to each other player.
  When a player is bankrupt, the game is over.
  What is the average number of turns required?

  If P = 0.5 (no bias) then the average is 4*L*M*N/3/(L+M+N-2)

    L  M  N    P  FLIPS

    1  1  1  0.5    4/3
    1  2  3  0.5    2
    2  3  4  0.5   32/7
    3  3  3  0.5   36/7
    4  7  9  0.5 1008/54

    1  1  1  04   100/72

    1  2  3  0.4   2.0814 (estimate)
    2  3  4  0.4   4.7721 (estimate)
    3  3  3  0.4   5.36   (estimate)
    4  7  9  0.4  19.4875 (estimate

    Paul Nahin,
    Digital Dice: Computational Solutions to Practical Probability Problems,
    Princeton, 2008,
'''


import random

NUM_ITERS = 100000

l,m,n = map(int, input("l m n=? ").split())
     # L, M, N, the number of dollars each player has at the start.

p = 0.5
# p = float(input("p=? "))      # the bias on the coins

flipsTotal = 0
for i in range(NUM_ITERS):

  # initialise this game
  numFlips = 0
  coinsLeft = [l, m, n]
  flips = [0,0,0]
  while coinsLeft[0] > 0 and coinsLeft[1] > 0 and coinsLeft[2] > 0:
    flips[0] = random.random( )
    flips[1] = random.random( )
    flips[2] = random.random( )
    for j in range(3):
      if flips[j] < p:
        flips[j] = 1   # head
      else:
        flips[j] = 0   # tail

    sumFlips = sum(flips)

    if sumFlips == 1 or sumFlips == 2:  # one or two heads
      if sumFlips == 1:   # one head is winner
        for j in range(3):
          if flips[j] == 0:  # remove a coin if got tails
            flips[j] = -1
          else:
            flips[j] = 2
      else:   # two heads, which means one tail is winner
        for j in range(3):
          if flips[j] == 0:  # got a tail
            flips[j] = 2
          else:  # remove a coin if got heads
            flips[j] = -1

      for j in range(3):    # update coin totals
        coinsLeft[j] += flips[j]

    numFlips += 1

  # this game is ended since someone has 0 coins
  flipsTotal += numFlips

print('Average number of turns:', (flipsTotal/NUM_ITERS))

